﻿unit Health_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const
Array_Items_HLT_AND_FITBIT_EVENT: TSQL_Table_array = (
 (sql_col: 'DNT_TIME';                        fex_col: 'Event Time';                        read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT__id';                         fex_col: 'Record ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ACCURACY';                    fex_col: 'Accuracy';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ALTITUDE';                    fex_col: 'Altitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BEARING';                     fex_col: 'Bearing';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LABEL';                       fex_col: 'Label';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_PACE';                        fex_col: 'Pace';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SESSION_ID';                  fex_col: 'Session ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SPEED';                       fex_col: 'Speed';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_AND_HEART_RATE_DAILY_SUMMARY: TSQL_Table_array = (
 (sql_col: 'DNT_DATE_TIME';                   fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_AVERAGE_HEART_RATE';          fex_col: 'Average Heart Rate';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_RESTING_HEART_RATE';          fex_col: 'Resting Heart Rate';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_AND_FITBIT_PROFILE: TSQL_Table_array = (
 (sql_col: 'DNT_TIME_CREATED';                fex_col: 'Time Created';                      read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_TIME_UPDATED';                fex_col: 'Time Updated';                      read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_UUID';                        fex_col: 'UUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_FIRST_NAME';                  fex_col: 'First Name';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LAST_NAME';                   fex_col: 'Last Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_FULL_NAME';                   fex_col: 'Full Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DISPLAY_NAME';                fex_col: 'Display Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_GENDER';                      fex_col: 'Gender';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DATE_OF_BIRTH';               fex_col: 'DOB';                               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_EMAIL';                       fex_col: 'Email';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_HEIGHT';                      fex_col: 'Height';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LOCALE';                      fex_col: 'Locale';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_PROFILE_PHOTO_LINK';          fex_col: 'Profile Photo';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_STRIDE_LENGTH_RUNNING';       fex_col: 'Stride Length Running';             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_STRIDE_LENGTH_WALKING';       fex_col: 'Stride Length Walking';             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TIME_ZONE';                   fex_col: 'Timezone';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TIME_ZONE_OFFSET';            fex_col: 'Timezone Offset';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_AND_GARMIN_ACTIVITIES: TSQL_Table_array = (
 (sql_col: 'DNT_SAVED_TIMESTAMP';             fex_col: 'Saved Timestamp';                   read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATA_TYPE';                   fex_col: 'Data Type';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CACHED_VAL';                  fex_col: 'Cached Value';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONCEPT_ID';                  fex_col: 'Concept ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_AND_GARMIN_ACTIVITY_DETAILS: TSQL_Table_array = (
 (sql_col: 'DNT_beginTimestamp';              fex_col: 'Start Timestamp';                   read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_startTimeLocal';              fex_col: 'Start Time Local';                  read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_activityName';                fex_col: 'Activity Name';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_activityTypeCategory';        fex_col: 'Activity Type';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_activityId';                  fex_col: 'Activity ID';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_eventTypeId';                 fex_col: 'Activity Type ID';                  read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_averageHR';                   fex_col: 'Heart Rate Ave.';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_averageSpeed';                fex_col: 'Speed Ave.';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_avgStrideLength';             fex_col: 'Stride Length Ave.';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_distance';                    fex_col: 'Distance';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_duration';                    fex_col: 'Duration';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_maxSpeed';                    fex_col: 'Max Speed';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_movingDuration';              fex_col: 'Moving Duration';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ownerDisplayName';            fex_col: 'Owner Name';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ownerId';                     fex_col: 'Owner ID';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ownerProfileImageUrlLarge';   fex_col: 'Owner Profile URL';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_startLatitude';               fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_startLongitude';              fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_steps';                       fex_col: 'Steps';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_DISTANCE: TSQL_Table_array = (
 (sql_col: 'DNT_Start_Date';                  fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_End_Date';                    fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_quantity';                    fex_col: 'Distance (Meters)';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_origin_product_type';         fex_col: 'Provenance';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_data_id';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_FLIGHTS_CLIMBED: TSQL_Table_array = (
 (sql_col: 'DNT_Start_Date';                  fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_End_Date';                    fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_quantity';                    fex_col: 'Flights Climbed';                   read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_origin_product_type';         fex_col: 'Provenance';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_data_id';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_HEART_RATE: TSQL_Table_array = (
 (sql_col: 'DNT_Start_Date';                  fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_End_Date';                    fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_original_quantity';           fex_col: 'Heart Rate';                        read_as: ftString;     convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_unit_string';                 fex_col: 'Unit';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_origin_product_type';         fex_col: 'Provenance';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_data_id';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_HEIGHT: TSQL_Table_array = (
 (sql_col: 'DNT_Start_Date';                  fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_End_Date';                    fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_quantity';                    fex_col: 'User Height';                       read_as: ftString;     convert_as: '';                col_type: ftFloat;     show: True),
 (sql_col: 'DNT_unit_string';                 fex_col: 'Unit';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_origin_product_type';         fex_col: 'Provenance';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_data_id';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_LATITUDE: TSQL_Table_array = (
 (sql_col: 'DNT_STARTY';                      fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ENDY';                        fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_WORKOUT TYPE';                fex_col: 'Workout';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DISTANCE_KM';                 fex_col: 'Distance (Km)';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DATA ID';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_LONGITUDE: TSQL_Table_array = (
 (sql_col: 'DNT_STARTY';                      fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ENDY';                        fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_WORKOUT TYPE';                fex_col: 'Workout';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DISTANCE_KM';                 fex_col: 'Distance (Km)';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DATA ID';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_STEPS: TSQL_Table_array = (
 (sql_col: 'DNT_Start_Date';                  fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_End_Date';                    fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_quantity';                    fex_col: 'Steps Taken';                       read_as: ftString;     convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_origin_product_type';         fex_col: 'Provenance';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_data_id';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_APPLE_HEALTH_WEIGHT: TSQL_Table_array = (
 (sql_col: 'DNT_Start_Date';                  fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_End_Date';                    fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_quantity';                    fex_col: 'User Weight (k)';                   read_as: ftString;     convert_as: '';                col_type: ftFloat;     show: True),
 (sql_col: 'DNT_origin_product_type';         fex_col: 'Provenance';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_data_id';                     fex_col: 'Data ID';                           read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_FITBIT_ACTIVITY_LOG: TSQL_Table_array = (
 (sql_col: 'DNT_ZSTARTTIME';                  fex_col: 'Fitbit Start Time';                 read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLASTMODIFIED';               fex_col: 'Fitbit Last Modified';              read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZNAME';                       fex_col: 'Activity Type';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZSTEPS';                      fex_col: 'Steps';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZDISTANCE';                   fex_col: 'Distance (Km)';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZAVERAGEHEARTRATE';           fex_col: 'Heart Rate Av. (BPM)';              read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_ZLOGID';                      fex_col: 'Log ID';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_HLT_IOS_FITBIT_USER: TSQL_Table_array = (
 (sql_col: 'DNT_ZDISPLAYNAME';                fex_col: 'Display Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZFIRSTNAME';                  fex_col: 'First Name';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLASTNAME';                   fex_col: 'Last Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZAVATAR';                     fex_col: 'Avatar';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZENCODEDID';                  fex_col: 'Encoded ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZGENDER';                     fex_col: 'Gender';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_NULL: TSQL_Table_array = (
 (sql_col: '';
 fex_col: '';
 read_as: ftString;
 convert_as: '';
 col_type: ftString;
 show: false));

begin
   if Name = 'HLT_AND_FITBIT_EVENT'                        then Result := Array_Items_HLT_AND_FITBIT_EVENT else
   if Name = 'HLT_AND_FITBIT_HEART_RATE_DAILY_SUMMARY'     then Result := Array_Items_HLT_AND_HEART_RATE_DAILY_SUMMARY else
   if Name = 'HLT_AND_FITBIT_PROFILE'                      then Result := Array_Items_HLT_AND_FITBIT_PROFILE else
   if Name = 'HLT_AND_GARMIN_ACTIVITIES'                   then Result := Array_Items_HLT_AND_GARMIN_ACTIVITIES else
   if Name = 'HLT_AND_GARMIN_ACTIVITY_DETAILS'             then Result := Array_Items_HLT_AND_GARMIN_ACTIVITY_DETAILS else
   if Name = 'HLT_IOS_APPLE_HEALTH_DISTANCE'               then Result := Array_Items_HLT_IOS_APPLE_HEALTH_DISTANCE else
   if Name = 'HLT_IOS_APPLE_HEALTH_FLIGHTS_CLIMBED'        then Result := Array_Items_HLT_IOS_APPLE_HEALTH_FLIGHTS_CLIMBED else
   if Name = 'HLT_IOS_APPLE_HEALTH_HEART_RATE'             then Result := Array_Items_HLT_IOS_APPLE_HEALTH_HEART_RATE else
   if Name = 'HLT_IOS_APPLE_HEALTH_HEIGHT'                 then Result := Array_Items_HLT_IOS_APPLE_HEALTH_HEIGHT else
   if Name = 'HLT_IOS_APPLE_HEALTH_LATITUDE'               then Result := Array_Items_HLT_IOS_APPLE_HEALTH_LATITUDE else
   if Name = 'HLT_IOS_APPLE_HEALTH_LONGITUDE'              then Result := Array_Items_HLT_IOS_APPLE_HEALTH_LONGITUDE else
   if Name = 'HLT_IOS_APPLE_HEALTH_STEPS'                  then Result := Array_Items_HLT_IOS_APPLE_HEALTH_STEPS else
   if Name = 'HLT_IOS_APPLE_HEALTH_WEIGHT'                 then Result := Array_Items_HLT_IOS_APPLE_HEALTH_WEIGHT else
   if Name = 'HLT_IOS_FITBIT_ACTIVITY_LOG'                 then Result := Array_Items_HLT_IOS_FITBIT_ACTIVITY_LOG else
   if Name = 'HLT_IOS_FITBIT_USER'                         then Result := Array_Items_HLT_IOS_FITBIT_USER else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Health' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
